<?php
class EvenFilterIterator extends FilterIterator {
  /**
   * Akceptuje tylko parzyste klucze
   * 
   * @return bool
   */
  public function accept()
  {
    // Pobranie iteratora
    $iterator = $this->getInnerIterator();
    // Pobranie bieżącego klucza
    $key = $iterator->key();
    // Sprawdzanie czy wartości są parzyste 
    if ($key % 2 == 0) {
      return true;
    }
    return false;
  }
}
$array = array(
  0 => "Cześć",
  1 => "Wszyscy",
  2 => "Jam jest",
  3 => "którzy",
  4 => "Twój",
  5 => "żyją",
  6 => "Doktor",
  7 => "są niesamowici"
);
// Utworzenie iteratora z tablicy
$iterator = new ArrayIterator($array);
// Utworzenie iteratora FilterIterator
$filterIterator = new EvenFilterIterator($iterator);
// Iteracja
foreach ($filterIterator as $key => $value) {
  echo '<pre>' . $key .': '. $value . '</pre>' . PHP_EOL;
}
?>